// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     chrome/common/resource_usage_reporter.mojom
//

package org.chromium.mojom;

public final class ResourceUsageData extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(40, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public boolean reportsV8Stats;
    public long v8BytesAllocated;
    public long v8BytesUsed;
    public ResourceTypeStats webCacheStats;

    private ResourceUsageData(int version) {
        super(STRUCT_SIZE, version);
        reportsV8Stats = (boolean) false;
        v8BytesAllocated = (long) 0L;
        v8BytesUsed = (long) 0L;
    }

    public ResourceUsageData() {
        this(0);
    }

    public static ResourceUsageData deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static ResourceUsageData decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        ResourceUsageData result = new ResourceUsageData(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.reportsV8Stats = decoder0.readBoolean(8, 0);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.v8BytesAllocated = decoder0.readLong(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.v8BytesUsed = decoder0.readLong(24);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, true);
            result.webCacheStats = ResourceTypeStats.decode(decoder1);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(reportsV8Stats, 8, 0);
        encoder0.encode(v8BytesAllocated, 16);
        encoder0.encode(v8BytesUsed, 24);
        encoder0.encode(webCacheStats, 32, true);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        ResourceUsageData other = (ResourceUsageData) object;
        if (this.reportsV8Stats != other.reportsV8Stats)
            return false;
        if (this.v8BytesAllocated != other.v8BytesAllocated)
            return false;
        if (this.v8BytesUsed != other.v8BytesUsed)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.webCacheStats, other.webCacheStats))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(reportsV8Stats);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(v8BytesAllocated);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(v8BytesUsed);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(webCacheStats);
        return result;
    }
}

